#!/usr/bin/python3
#!venv/bin/python3



import glob
import pyglet
import numpy
import json

jmeno = input('Jmeno mapy: ')
if 'mapy/' + jmeno + '.json' in glob.glob('mapy/*'):
    with open('mapy/'+jmeno+'.json') as soubor:
            data = json.load(soubor)
            mapa = data[0]
            px = data[1][1]
            py = data[1][0]
            velikost_x = len(mapa[0])
            velikost_y = len(mapa)
else:
    try:
        velikost_x = int(input('Sirka mapy (ve ctvereccich; max. 88): '))
    except:
        velikost_x = 15
    try:
        velikost_y = int(input('Vyska mapy (ve ctvereccich; max. 51): '))
    except:
        velikost_y = 15
    mapa = list(numpy.zeros((velikost_y,velikost_x)))
    for i in range(velikost_y):
        mapa[i] = list(mapa[i])
    mapa[0] = [1]*velikost_x
    mapa[-1] = [1]*velikost_x
    for i in range(len(mapa)):
        mapa[i][0] = 1
        mapa[i][-1] = 1
    for i in range(len(mapa)):
        for y in range(len(mapa[i])):
            mapa[i][y] = int(mapa[i][y])
    px = 1
    py = 1
window = pyglet.window.Window(width = velikost_x*20,height = velikost_y*20)
zed = pyglet.image.load('obrazky/zed.png')
bedna = pyglet.image.load('obrazky/bedna.png')
cil = pyglet.image.load('obrazky/cil.png')
hrac = pyglet.image.load('obrazky/hrac.png')
spoustec = pyglet.image.load('obrazky/spoustec.png')
vybrany = 0
vybrano = 1
konec = False
porad = False
batch = pyglet.graphics.Batch()
pozice_mysi = {'x' : 0, 'y' : 0}
kliknuto = None
sprites = []
klavesy = []
co_to_znamena = {
0:'nic',
1:'zed',
2:'bedna',
3:'cil',
4:'spoustec'
}

def stisk_klavesy(klavesa, modifikatory):
    global vybrano, mapa, pozice, konec, py, px
    if klavesa == pyglet.window.key.D:
        vybrano += 1
        if vybrano == 5:
            vybrano = 0
    elif klavesa == pyglet.window.key.A:
        py = len(mapa)-pozice_mysi['y']//20-1
        px = pozice_mysi['x']//20
    elif klavesa == pyglet.window.key.S:
        mapa = list(numpy.full((velikost_y,velikost_x),vybrano))
        for i in range(velikost_y):
            mapa[i] = list(mapa[i])
        mapa[0] = [1]*velikost_x
        mapa[-1] = [1]*velikost_x
        for i in range(len(mapa)):
            mapa[i][0] = 1
            mapa[i][-1] = 1
        for i in range(len(mapa)):
            for y in range(len(mapa[i])):
                mapa[i][y] = int(mapa[i][y])
    elif klavesa == pyglet.window.key.F1:
        vybrano = 0
    elif klavesa == pyglet.window.key.F2:
        vybrano = 1
    elif klavesa == pyglet.window.key.F3:
        vybrano = 2
    elif klavesa == pyglet.window.key.F4:
        vybrano = 3
    elif klavesa == pyglet.window.key.F5:
        vybrano = 4
    elif klavesa == pyglet.window.key.F:
        jmeno_souboru = jmeno
        with open('mapy/'+jmeno_souboru+'.json', mode = 'w') as soubor:
            pozice = [py,px]
            soubor.write(json.dumps([mapa,pozice]))
        konec = True

def stisk(x, y, tlacitko, modifikatory):
    global kliknuto, porad
    kliknuto = {'x' : x, 'y' : y, 'tlacitko' : tlacitko}
    if tlacitko == 2:
        if porad == True:
            porad = False
        else:
            porad = True

def pohyb(x, y, dx, dy):
    global pozice_mysi
    pozice_mysi = {'x' : x, 'y' : y}

def pusteni(x, y, tlacitko, modifikatory):
    global kliknuto
    kliknuto = None

def kresleni():
    try:
        if kliknuto['tlacitko'] == 1:
            mapa[len(mapa)-kliknuto['y']//20-1][kliknuto['x']//20] = vybrano
        elif kliknuto['tlacitko'] == 4:
            mapa[len(mapa)-kliknuto['y']//20-1][kliknuto['x']//20] = 0
    except:
        pass
    try:
        if porad == True:
            mapa[len(mapa)-pozice_mysi['y']//20-1][pozice_mysi['x']//20] = vybrano
    except:
        pass

def tik(dt):
    kresleni()
    if konec:
        exit('SAVE')
    print('Vybrano:',co_to_znamena[vybrano])


def zavreno():
    exit()

def vykresli():
    global sprites
    sprites.clear()
    window.clear()
    mapa.reverse()
    for y in range(len(mapa)):
        for x in range(len(mapa[y])):
            if mapa[y][x] == 0:
                if px == x and py == len(mapa)-y-1:
                    sprites.append(pyglet.sprite.Sprite(hrac,x=x*20,y=y*20,batch=batch))
            if mapa[y][x] == 1:
                sprites.append(pyglet.sprite.Sprite(zed,x=x*20,y=y*20,batch=batch))
            if mapa[y][x] == 2:
                sprites.append(pyglet.sprite.Sprite(bedna,x=x*20,y=y*20,batch=batch))
            if mapa[y][x] == 3:
                sprites.append(pyglet.sprite.Sprite(cil,x=x*20,y=y*20,batch=batch))
            if mapa[y][x] == 4:
                sprites.append(pyglet.sprite.Sprite(spoustec,x=x*20,y=y*20,batch=batch))
                if px == x and py == len(mapa)-y-1:
                    sprites.append(pyglet.sprite.Sprite(hrac,x=x*20,y=y*20,batch=batch))
    mapa.reverse()
    batch.draw()
    sprites.clear()

window.push_handlers(
on_draw = vykresli,
on_mouse_press = stisk,
on_mouse_motion = pohyb,
on_mouse_release = pusteni,
on_key_press = stisk_klavesy,
on_close = zavreno,
)

pyglet.clock.schedule(tik)

pyglet.app.run()
